# cython_metric.pyx
from libc.math cimport fabs
from numpy cimport ndarray
import numpy as np
cimport numpy as np
from cython cimport boundscheck, wraparound

@boundscheck(False)
@wraparound(False)
def mixed_distance(ndarray[np.float64_t, ndim=1] x,
                   ndarray[np.float64_t, ndim=1] y,
                   np.int_t categoric_slice):
    cdef Py_ssize_t n = x.shape[0]
    cdef Py_ssize_t i = 0
    cdef double res = 0.0
    for i in range(categoric_slice):
        res += (x[i] != y[i])
    for i in range(categoric_slice, n):
        res += fabs(x[i] - y[i])
    return res